#include <iostream>   // ?? cin, cout
#include <vector>     // ?? std::vector
#include <cmath>      // ?? abs
#include <algorithm>  // ?? std::min
using namespace std;

struct Point {
    double x, y;
};

double manhattan(const Point &a, const Point &b) {
    return abs(a.x - b.x) + abs(a.y - b.y);
}

int main() {
    int n;
    double eps;
    cin >> n >> eps;
    vector<Point> pts(n);
    for(int i=0;i<n;i++)
        cin >> pts[i].x >> pts[i].y;

    // Jednostavna heuristika: uzmemo sve tacke
    vector<int> Q(n);
    for(int i=0;i<n;i++) Q[i] = i+1;

    // Pravimo MST nad izabranim tackama (primena Primovog algoritma)
    vector<int> parent(n,-1);
    vector<double> key(n,1e9);
    vector<bool> inMST(n,false);
    key[0]=0;

    for(int count=0;count<n;count++){
        // find min key
        int u=-1;
        for(int i=0;i<n;i++)
            if(!inMST[i] && (u==-1 || key[i]<key[u])) u=i;
        inMST[u]=true;

        for(int v=0;v<n;v++){
            if(!inMST[v]){
                double d = manhattan(pts[u], pts[v]);
                if(d < key[v]){
                    key[v]=d;
                    parent[v]=u;
                }
            }
        }
    }

    // Ispis
    cout << n << "\n";
    for(int i=0;i<n;i++) cout << Q[i] << " ";
    cout << "\n";
    for(int i=1;i<n;i++)
        cout << parent[i]+1 << " " << i+1 << "\n";

    return 0;
}